﻿// Listing 1-5 zawiera 4 poniższe dyrektywy using
using System.IO;
using System.Windows.Media;

using IoPath = System.IO.Path;
using WpfPath = System.Windows.Shapes.Path;

using System.Linq;
using System.Windows.Shapes;
using System.Windows;

namespace PathsForExample5
{
    // To nieco rozbudowany przykład, gdyz jego celem jest jedynie pokazanie sposobów
    // korzystania z nazw zastępczych przestrzeni nazw. Generuje on jedynie element Path
    // reprezentujący sumaryczną wielkość wszystkich plików w konkretnym katalogu.
    // Ten kod nie obsługuje żadnych błędów, jak również nie radzi sobie najlepiej 
    // z rożnymi katalogami ukrytymi, które system Windows umieszcza w katalug Dokuments.
    // Nie ma on służyć jako przykład operowania na systemie plików.
    public class GetFileShapes
    {
        public static WpfPath GetShapeRepresentingContentSize(string folderPath)
        {
            string fullPath = IoPath.GetFullPath(folderPath);
            var fileSizes = from file in Directory.GetFiles(fullPath, "*", SearchOption.AllDirectories)
                            select new FileInfo(file).Length;
            long totalSize = fileSizes.Sum();

            return new WpfPath
            {
                Fill = Brushes.Blue,
                Data = new RectangleGeometry(new Rect(0, 0, totalSize / 100000, 20))
            };
        }
    }
}
